/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.mixins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.resources.AssetIndex;
import net.minecraft.client.resources.ClientPackSource;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.CefUtil;
import net.montoyo.mcef.utilities.download.MCEFDownloader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPackSource.class})
public class CefInitMixin {
    private static void setupLibraryPath() {
        Path minecraftPath = Paths.get("", new String[0]);
        Path modsPath = minecraftPath.resolve("mods");
        Path cinemaModLibrariesPath = modsPath.resolve("cinemamod-libraries");
        if (Files.notExists(cinemaModLibrariesPath, new LinkOption[0])) {
            try {
                Files.createDirectory(cinemaModLibrariesPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.setProperty("cinemamod.libraries.path", cinemaModLibrariesPath.toAbsolutePath().toString());
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void cefInit(File p_118553_, AssetIndex p_118554_, CallbackInfo ci) {
        MCEF.ensureConfig();
        CefInitMixin.setupLibraryPath();
        Thread td = new Thread(() -> {
            MCEFDownloader.main(new String[0]);
            CefUtil.setReady();
        });
        td.setDaemon(true);
        td.setName("JCEF-Downloader");
        td.start();
    }
}

